// sse.js
const clients = [];
function eventsHandler(req, res) {
    res.setHeader("Content-Type", "text/event-stream");
    res.setHeader("Cache-Control", "no-cache");
    res.setHeader("Connection", "keep-alive");
    clients.push(res);
    req.on("close", () => {
        clients.splice(clients.indexOf(res), 1);
    });
}
function sendLogToClients(log) {
    clients.forEach(res => res.write(`data: ${log}\n\n`));
}
module.exports = { eventsHandler, sendLogToClients };
